/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.UintMap;

public class Decompiler {
    public static final int ONLY_BODY_FLAG = 1;
    public static final int TO_SOURCE_FLAG = 2;
    public static final int INITIAL_INDENT_PROP = 1;
    public static final int INDENT_GAP_PROP = 2;
    public static final int CASE_GAP_PROP = 3;
    private static final int FUNCTION_END = 164;
    private char[] sourceBuffer = new char[128];
    private int sourceTop;
    private static final boolean printSource = false;

    String getEncodedSource() {
        return this.sourceToString(0);
    }

    int getCurrentOffset() {
        return this.sourceTop;
    }

    int markFunctionStart(int functionType) {
        int savedOffset = this.getCurrentOffset();
        this.addToken(109);
        this.append((char)functionType);
        return savedOffset;
    }

    int markFunctionEnd(int functionStart) {
        int offset = this.getCurrentOffset();
        this.append('\u00a4');
        return offset;
    }

    void addToken(int token2) {
        if (0 > token2 || token2 > 163) {
            throw new IllegalArgumentException();
        }
        this.append((char)token2);
    }

    void addEOL(int token2) {
        if (0 > token2 || token2 > 163) {
            throw new IllegalArgumentException();
        }
        this.append((char)token2);
        this.append('\u0001');
    }

    void addName(String str) {
        this.addToken(39);
        this.appendString(str);
    }

    void addString(String str) {
        this.addToken(41);
        this.appendString(str);
    }

    void addRegexp(String regexp, String flags) {
        this.addToken(48);
        this.appendString('/' + regexp + '/' + flags);
    }

    void addNumber(double n) {
        this.addToken(40);
        long lbits = (long)n;
        if ((double)lbits != n) {
            lbits = Double.doubleToLongBits(n);
            this.append('D');
            this.append((char)(lbits >> 48));
            this.append((char)(lbits >> 32));
            this.append((char)(lbits >> 16));
            this.append((char)lbits);
        } else {
            if (lbits < 0L) {
                Kit.codeBug();
            }
            if (lbits <= 65535L) {
                this.append('S');
                this.append((char)lbits);
            } else {
                this.append('J');
                this.append((char)(lbits >> 48));
                this.append((char)(lbits >> 32));
                this.append((char)(lbits >> 16));
                this.append((char)lbits);
            }
        }
    }

    private void appendString(String str) {
        int nextTop;
        int L = str.length();
        int lengthEncodingSize = 1;
        if (L >= 32768) {
            lengthEncodingSize = 2;
        }
        if ((nextTop = this.sourceTop + lengthEncodingSize + L) > this.sourceBuffer.length) {
            this.increaseSourceCapacity(nextTop);
        }
        if (L >= 32768) {
            this.sourceBuffer[this.sourceTop] = (char)(0x8000 | L >>> 16);
            ++this.sourceTop;
        }
        this.sourceBuffer[this.sourceTop] = (char)L;
        ++this.sourceTop;
        str.getChars(0, L, this.sourceBuffer, this.sourceTop);
        this.sourceTop = nextTop;
    }

    private void append(char c) {
        if (this.sourceTop == this.sourceBuffer.length) {
            this.increaseSourceCapacity(this.sourceTop + 1);
        }
        this.sourceBuffer[this.sourceTop] = c;
        ++this.sourceTop;
    }

    private void increaseSourceCapacity(int minimalCapacity) {
        int newCapacity;
        if (minimalCapacity <= this.sourceBuffer.length) {
            Kit.codeBug();
        }
        if ((newCapacity = this.sourceBuffer.length * 2) < minimalCapacity) {
            newCapacity = minimalCapacity;
        }
        char[] tmp = new char[newCapacity];
        System.arraycopy(this.sourceBuffer, 0, tmp, 0, this.sourceTop);
        this.sourceBuffer = tmp;
    }

    private String sourceToString(int offset) {
        if (offset < 0 || this.sourceTop < offset) {
            Kit.codeBug();
        }
        return new String(this.sourceBuffer, offset, this.sourceTop - offset);
    }

    public static String decompile(String source, int flags, UintMap properties) {
        int topFunctionType;
        int length = source.length();
        if (length == 0) {
            return "";
        }
        int indent2 = properties.getInt(1, 0);
        if (indent2 < 0) {
            throw new IllegalArgumentException();
        }
        int indentGap = properties.getInt(2, 4);
        if (indentGap < 0) {
            throw new IllegalArgumentException();
        }
        int caseGap = properties.getInt(3, 2);
        if (caseGap < 0) {
            throw new IllegalArgumentException();
        }
        StringBuffer result2 = new StringBuffer();
        boolean justFunctionBody = 0 != (flags & 1);
        boolean toSource = 0 != (flags & 2);
        int braceNesting = 0;
        boolean afterFirstEOL = false;
        int i = 0;
        if (source.charAt(i) == '\u0088') {
            ++i;
            topFunctionType = -1;
        } else {
            topFunctionType = source.charAt(i + 1);
        }
        if (!toSource) {
            result2.append('\n');
            for (int j = 0; j < indent2; ++j) {
                result2.append(' ');
            }
        } else if (topFunctionType == 2) {
            result2.append('(');
        }
        block100: while (i < length) {
            switch (source.charAt(i)) {
                case '\u0097': 
                case '\u0098': {
                    result2.append(source.charAt(i) == '\u0097' ? "get " : "set ");
                    ++i;
                    i = Decompiler.printSourceString(source, i + 1, false, result2);
                    ++i;
                    break;
                }
                case '\'': 
                case '0': {
                    i = Decompiler.printSourceString(source, i + 1, false, result2);
                    continue block100;
                }
                case ')': {
                    i = Decompiler.printSourceString(source, i + 1, true, result2);
                    continue block100;
                }
                case '(': {
                    i = Decompiler.printSourceNumber(source, i + 1, result2);
                    continue block100;
                }
                case '-': {
                    result2.append("true");
                    break;
                }
                case ',': {
                    result2.append("false");
                    break;
                }
                case '*': {
                    result2.append("null");
                    break;
                }
                case '+': {
                    result2.append("this");
                    break;
                }
                case 'm': {
                    ++i;
                    result2.append("function ");
                    break;
                }
                case '\u00a4': {
                    break;
                }
                case 'Y': {
                    result2.append(", ");
                    break;
                }
                case 'U': {
                    ++braceNesting;
                    if (1 == Decompiler.getNext(source, length, i)) {
                        indent2 += indentGap;
                    }
                    result2.append('{');
                    break;
                }
                case 'V': {
                    if (justFunctionBody && --braceNesting == 0) break;
                    result2.append('}');
                    switch (Decompiler.getNext(source, length, i)) {
                        case 1: 
                        case 164: {
                            indent2 -= indentGap;
                            break;
                        }
                        case 113: 
                        case 117: {
                            indent2 -= indentGap;
                            result2.append(' ');
                        }
                    }
                    break;
                }
                case 'W': {
                    result2.append('(');
                    break;
                }
                case 'X': {
                    result2.append(')');
                    if (85 != Decompiler.getNext(source, length, i)) break;
                    result2.append(' ');
                    break;
                }
                case 'S': {
                    result2.append('[');
                    break;
                }
                case 'T': {
                    result2.append(']');
                    break;
                }
                case '\u0001': {
                    int afterName;
                    if (toSource) break;
                    boolean newLine = true;
                    if (!afterFirstEOL) {
                        afterFirstEOL = true;
                        if (justFunctionBody) {
                            result2.setLength(0);
                            indent2 -= indentGap;
                            newLine = false;
                        }
                    }
                    if (newLine) {
                        result2.append('\n');
                    }
                    if (i + 1 >= length) break;
                    int less2 = 0;
                    char nextToken = source.charAt(i + 1);
                    if (nextToken == 's' || nextToken == 't') {
                        less2 = indentGap - caseGap;
                    } else if (nextToken == 'V') {
                        less2 = indentGap;
                    } else if (nextToken == '\'' && source.charAt(afterName = Decompiler.getSourceStringEnd(source, i + 2)) == 'g') {
                        less2 = indentGap;
                    }
                    while (less2 < indent2) {
                        result2.append(' ');
                        ++less2;
                    }
                    break;
                }
                case 'l': {
                    result2.append('.');
                    break;
                }
                case '\u001e': {
                    result2.append("new ");
                    break;
                }
                case '\u001f': {
                    result2.append("delete ");
                    break;
                }
                case 'p': {
                    result2.append("if ");
                    break;
                }
                case 'q': {
                    result2.append("else ");
                    break;
                }
                case 'w': {
                    result2.append("for ");
                    break;
                }
                case '4': {
                    result2.append(" in ");
                    break;
                }
                case '{': {
                    result2.append("with ");
                    break;
                }
                case 'u': {
                    result2.append("while ");
                    break;
                }
                case 'v': {
                    result2.append("do ");
                    break;
                }
                case 'Q': {
                    result2.append("try ");
                    break;
                }
                case '|': {
                    result2.append("catch ");
                    break;
                }
                case '}': {
                    result2.append("finally ");
                    break;
                }
                case '2': {
                    result2.append("throw ");
                    break;
                }
                case 'r': {
                    result2.append("switch ");
                    break;
                }
                case 'x': {
                    result2.append("break");
                    if (39 != Decompiler.getNext(source, length, i)) break;
                    result2.append(' ');
                    break;
                }
                case 'y': {
                    result2.append("continue");
                    if (39 != Decompiler.getNext(source, length, i)) break;
                    result2.append(' ');
                    break;
                }
                case 's': {
                    result2.append("case ");
                    break;
                }
                case 't': {
                    result2.append("default");
                    break;
                }
                case '\u0004': {
                    result2.append("return");
                    if (82 == Decompiler.getNext(source, length, i)) break;
                    result2.append(' ');
                    break;
                }
                case 'z': {
                    result2.append("var ");
                    break;
                }
                case '\u0099': {
                    result2.append("let ");
                    break;
                }
                case 'R': {
                    result2.append(';');
                    if (1 == Decompiler.getNext(source, length, i)) break;
                    result2.append(' ');
                    break;
                }
                case 'Z': {
                    result2.append(" = ");
                    break;
                }
                case 'a': {
                    result2.append(" += ");
                    break;
                }
                case 'b': {
                    result2.append(" -= ");
                    break;
                }
                case 'c': {
                    result2.append(" *= ");
                    break;
                }
                case 'd': {
                    result2.append(" /= ");
                    break;
                }
                case 'e': {
                    result2.append(" %= ");
                    break;
                }
                case '[': {
                    result2.append(" |= ");
                    break;
                }
                case '\\': {
                    result2.append(" ^= ");
                    break;
                }
                case ']': {
                    result2.append(" &= ");
                    break;
                }
                case '^': {
                    result2.append(" <<= ");
                    break;
                }
                case '_': {
                    result2.append(" >>= ");
                    break;
                }
                case '`': {
                    result2.append(" >>>= ");
                    break;
                }
                case 'f': {
                    result2.append(" ? ");
                    break;
                }
                case 'B': {
                    result2.append(':');
                    break;
                }
                case 'g': {
                    if (1 == Decompiler.getNext(source, length, i)) {
                        result2.append(':');
                        break;
                    }
                    result2.append(" : ");
                    break;
                }
                case 'h': {
                    result2.append(" || ");
                    break;
                }
                case 'i': {
                    result2.append(" && ");
                    break;
                }
                case '\t': {
                    result2.append(" | ");
                    break;
                }
                case '\n': {
                    result2.append(" ^ ");
                    break;
                }
                case '\u000b': {
                    result2.append(" & ");
                    break;
                }
                case '.': {
                    result2.append(" === ");
                    break;
                }
                case '/': {
                    result2.append(" !== ");
                    break;
                }
                case '\f': {
                    result2.append(" == ");
                    break;
                }
                case '\r': {
                    result2.append(" != ");
                    break;
                }
                case '\u000f': {
                    result2.append(" <= ");
                    break;
                }
                case '\u000e': {
                    result2.append(" < ");
                    break;
                }
                case '\u0011': {
                    result2.append(" >= ");
                    break;
                }
                case '\u0010': {
                    result2.append(" > ");
                    break;
                }
                case '5': {
                    result2.append(" instanceof ");
                    break;
                }
                case '\u0012': {
                    result2.append(" << ");
                    break;
                }
                case '\u0013': {
                    result2.append(" >> ");
                    break;
                }
                case '\u0014': {
                    result2.append(" >>> ");
                    break;
                }
                case ' ': {
                    result2.append("typeof ");
                    break;
                }
                case '~': {
                    result2.append("void ");
                    break;
                }
                case '\u009a': {
                    result2.append("const ");
                    break;
                }
                case 'H': {
                    result2.append("yield ");
                    break;
                }
                case '\u001a': {
                    result2.append('!');
                    break;
                }
                case '\u001b': {
                    result2.append('~');
                    break;
                }
                case '\u001c': {
                    result2.append('+');
                    break;
                }
                case '\u001d': {
                    result2.append('-');
                    break;
                }
                case 'j': {
                    result2.append("++");
                    break;
                }
                case 'k': {
                    result2.append("--");
                    break;
                }
                case '\u0015': {
                    result2.append(" + ");
                    break;
                }
                case '\u0016': {
                    result2.append(" - ");
                    break;
                }
                case '\u0017': {
                    result2.append(" * ");
                    break;
                }
                case '\u0018': {
                    result2.append(" / ");
                    break;
                }
                case '\u0019': {
                    result2.append(" % ");
                    break;
                }
                case '\u0090': {
                    result2.append("::");
                    break;
                }
                case '\u008f': {
                    result2.append("..");
                    break;
                }
                case '\u0092': {
                    result2.append(".(");
                    break;
                }
                case '\u0093': {
                    result2.append('@');
                    break;
                }
                case '\u00a0': {
                    result2.append("debugger;\n");
                    break;
                }
                default: {
                    throw new RuntimeException("Token: " + Token.name(source.charAt(i)));
                }
            }
            ++i;
        }
        if (!toSource) {
            if (!justFunctionBody) {
                result2.append('\n');
            }
        } else if (topFunctionType == 2) {
            result2.append(')');
        }
        return result2.toString();
    }

    private static int getNext(String source, int length, int i) {
        return i + 1 < length ? (int)source.charAt(i + 1) : 0;
    }

    private static int getSourceStringEnd(String source, int offset) {
        return Decompiler.printSourceString(source, offset, false, null);
    }

    private static int printSourceString(String source, int offset, boolean asQuotedString, StringBuffer sb) {
        int length = source.charAt(offset);
        ++offset;
        if ((0x8000 & length) != 0) {
            length = (Short.MAX_VALUE & length) << 16 | source.charAt(offset);
            ++offset;
        }
        if (sb != null) {
            String str = source.substring(offset, offset + length);
            if (!asQuotedString) {
                sb.append(str);
            } else {
                sb.append('\"');
                sb.append(ScriptRuntime.escapeString(str));
                sb.append('\"');
            }
        }
        return offset + length;
    }

    private static int printSourceNumber(String source, int offset, StringBuffer sb) {
        double number2 = 0.0;
        char type = source.charAt(offset);
        ++offset;
        if (type == 'S') {
            if (sb != null) {
                char ival = source.charAt(offset);
                number2 = ival;
            }
            ++offset;
        } else if (type == 'J' || type == 'D') {
            if (sb != null) {
                long lbits = (long)source.charAt(offset) << 48;
                lbits |= (long)source.charAt(offset + 1) << 32;
                lbits |= (long)source.charAt(offset + 2) << 16;
                number2 = type == 'J' ? (double)lbits : Double.longBitsToDouble(lbits |= (long)source.charAt(offset + 3));
            }
            offset += 4;
        } else {
            throw new RuntimeException();
        }
        if (sb != null) {
            sb.append(ScriptRuntime.numberToString(number2, 10));
        }
        return offset;
    }
}

